#define NONORMAL
#include "InventorBasicEffectDx10.fxh"


struct VSPos
{
	float3 Pos			: Position;
#ifdef COLOR
	float4 Col			: Color;
#endif
	#ifdef DIFFUSE_TEXTURE
	float2 Tex			: TexCoord;
	#endif	
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_Pos( VSPos Input,uniform float2 offset)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	Out.Pos = mul(LocalPos, g_matWorldViewProj);

	if(Out.Pos.w > 0.0f)
	{
		//In orthographics mode, Out.Pos.w is always 1.0f, so this is not a problem.
		//But in perspective mode, if Out.Pos.w <= 0, that means we are out of the view frustum
		//and we can't do the following computation otherwise there will be some problem. see DID 1288930
		Out.Pos.xyz /= Out.Pos.w;
		Out.Pos.w = 1.0f;
		Out.Pos.xy += offset.xy;
	}
	
	//float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	//float Opacity = g_Misc.y;
	//TripleColor Color = CalcLightingAmb(Input.Pos, g_Emissive, g_Ambient, Opacity);
#ifdef COLOR
	//Input color is compressed as a Dword in vertex buffer. 
	//But Dx9 is incompatiable to translate this Dword into float4 with Dx10. Dx9 treats Dword as ARGB. Dx10 treats Dword as ABGR.
	//And Dword is padding with order ARGB in application layer. So a translation is needed in Dx10.
	Out.ColorD.xyzw = Input.Col.zyxw;
#else	
	Out.ColorD = g_Emissive;
	Out.ColorD.w = g_Misc.y;
#endif
		
	//Apply user specified clipping
	Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
	Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
	if( g_bClippingEnable )
	{
		CalcClipping(LocalPos, Out);
	}
    #ifdef DIFFUSE_TEXTURE
	Out.Tex = float4(Input.Tex, 0, 1.0f);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
	#endif
	return Out;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_Pos( VSOutput Input ) : SV_Target
{
	if(Input.ColorD.a < g_Misc.w)
		discard;
	#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
	#endif
	float4 Color = saturate(Input.ColorD);
	return Color;
}

#ifdef TWO_PIXEL_WIDE

// wide line:2 pixels' width
//Actually 4 passes are needed: offset table is like this:(0,0),(0,1),(1,0),(1,1)
technique10 WideLine2pixels
{
    pass P0
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(0.0f,0.0f))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P1
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(0.0f,-2.0f/g_ViewPort.y))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P2
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(2.0f/g_ViewPort.x,0.0f))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P3
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(2.0f/g_ViewPort.x, -2.0f/g_ViewPort.y))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
}

#endif

#ifdef THREE_PIXEL_WIDE
// wide line:3 pixels' width
//Actually 5 passes are needed: offset table is like this:(0,-1),(-1,0),(0,0),(1,0),(0,1)
technique10 WideLine3pixels
{
    pass P0
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(0.0f,2.0f/g_ViewPort.y))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P1
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(-2.0f/g_ViewPort.x,0.0f))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P2
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(0.0f,0.0f))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P3
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(2.0f/g_ViewPort.x,0.0f))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P4
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(0.0f,-2.0f/g_ViewPort.y))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
}

#endif

#ifdef FOUR_PIXEL_WIDE

// wide line:4 or more pixels' width
//Actually 12 passes are needed: offset table is like this:(0,-1),(1,-1),(-1,0),(0,0),(1,0),(2,0),(-1,1),(0,1),(1,1),(2,1),(0,2),(1,2)
technique10 WideLine4pixels
{
    pass P0
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(0.0f,2.0f/g_ViewPort.y))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P1
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(2.0f/g_ViewPort.x,2.0f/g_ViewPort.y))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P2
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(-2.0f/g_ViewPort.x,0.0f))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P3
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(0.0f,0.0f))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P4
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(2.0f/g_ViewPort.x,0.0f))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P5
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(2*2.0f/g_ViewPort.x,0.0f))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P6
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(-2.0f/g_ViewPort.x,-2.0f/g_ViewPort.y))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P7
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(0.0f,-2.0f/g_ViewPort.y))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P8
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(2.0f/g_ViewPort.x,-2.0f/g_ViewPort.y))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P9
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(2*2.0f/g_ViewPort.x,-2.0f/g_ViewPort.y))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P10
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(0.0f,-2*2.0f/g_ViewPort.y))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
    pass P11
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos(float2(2.0f/g_ViewPort.x,-2*2.0f/g_ViewPort.y))));
	SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0,PS_Pos()));
    }
   
}

#endif